/**
 * jQuery Easy Lightbox Gallery plugin
 * This jQuery plugin was inspired and based on http://leandrovieira.com/projects/jquery/lightbox/
 * Improved and maked compatable to CMS by Valiano for codecanyon.net
  * @author Valiano - http://codecanyon.net/user/valiano/
 * @version 1.0
 * @date October 10 2010
 * @category jQuery plugin
 * @copyright (c) 2010 Valiano development 
  */

(function($){
	
	var globals = {
	    settings:{},
		options:{},
		catlist:{},
		cache:{},
		current_category:"",
		isGalleryActive:false
	};

     $.fn.extend({
	 	
        putEasyGallery: function(options){
					   
		   var responseMessage = "Error loading gallery , please check the CMS url.";
		   
		   if(!options) var options = {};
		   
		   var defaults = { 
				url_server:"admin/gallery.php",		//a url to the CMS - gallery.php in admin folder
				nav_custom:"",						//custom navigation container
				nav_hor:"",							//horizonatal navigation container
				nav_vert:"",						//vertical navigation container
				catid:"",							//category id
				event_before_load:null,				//before image data load event function
				event_after_load:null,				//after image data load event function
				event_nav_click:null,				//on navigation item click event function
				event_get_catlist:null				//event that return categories list when the list is ready
		   };
		   	
			//set final options - from options or from memory
			var final_options = {};
			if(globals.isGalleryActive == false){
				$.extend(final_options,defaults,options);
				globals.options = final_options;
			}else{
				//copy final_options from globals
				final_options = globals.options;
				
				//extend category id from data
				if(options.catid)				
					final_options.catid = options.catid;
			}
			
		   //-----------------------------------
		   
			//load the gallery css
			loadCssFile(final_options["url_server"]+"?action=getcss");
			
            this.each(function(){
				var deeplink_catid = "";
				var t = this;
				
				//call ajax to get weather
				$(document).ready(function() {
					
					//prevent click on active category
					if(final_options.catid != ""){
						if(globals.current_category	!= "" && Number(final_options.catid) == Number(globals.current_category))
						return(false);
						globals.current_category = final_options.catid;
					}
					
					//if the navigation is from js nav item - change selected item.
					if(options.fromnavitem){
						activateEvent("nav_click");
						changeSelectedNavItem(options.fromnavitem);
						if(globals.settings.navigation_deeplink == "true")
							setDeeplink(final_options.catid);
						
						//check the data from cache
						if(globals.settings.enable_caching == "true"){
							if(isInCache(final_options.catid)){
								var items = getFromCache(final_options.catid);
								init_gallery(items,t);
								return(false);
							}
						}
					}
					else{		//if first time:
						// Get catid from deeplink if deeplink enabled. 
						// The server will deside if to use it
						deeplink_catid = getDeeplink();	
					}
					
					activateEvent("before_load");						
					$.ajax({
					      url: final_options["url_server"],
					      global: false,
					      type: "POST",
					      data:({
								 catid:final_options.catid,
								 deeplink_catid:deeplink_catid,
								 active:globals.isGalleryActive
								}),
					      dataType: "html",
					      async:true,
					      success: function(response){
							activateEvent("after_load");
							var objResponse = eval("(" + response + ")");
							
							if(!objResponse.success || objResponse.success != true){
								var message = "";
								if(objResponse.message)
									message = objResponse.message;
								errorOutput(t,message);
								return(false);
							}
							
							//set settings object. From response, or from globals
							if(globals.isGalleryActive == false){
								globals.settings = objResponse.settings;
								globals.current_category = globals.settings.category;
							}
							
							//cache recieved data data:
							if(globals.settings.enable_caching == "true"){
								if(final_options.catid != "")
									cacheData(final_options.catid,objResponse.items);
								else
									cacheData(globals.settings.category,objResponse.items);
							}
								
							//start the gallery, and put gallery html
							init_gallery(objResponse.items,t);
							
							//put navigation html
							if(globals.isGalleryActive == false){
								globals.catlist = objResponse.catlist;
								activateEvent("get_catlist");
								if(final_options.nav_custom != "")
									putNavigation(t.id,final_options.nav_custom,"custom",final_options);
									
								if(final_options.nav_hor != "")
									putNavigation(t.id,final_options.nav_hor,"hor",final_options);
									
								if(final_options.nav_vert != "")
									putNavigation(t.id,final_options.nav_vert,"vert",final_options);
							}
							
							globals.isGalleryActive = true;
					      },
						  error:function(){
							  errorOutput(t);
						  }
					   }
					)
				 });
            });
			
			//=========== Cache functions ===================
			
			//-----------------------------------------------
			//check that current category images is in cache
			function isInCache(catID){
				if(globals.cache[catID]) return(true);
				else return(false);
			}
			
			//-----------------------------------------------
			//cache the data by category id
			function cacheData(catID,items){
				globals.cache[catID] = items;
			}
			
			//-----------------------------------------------
			//get category items from cache
			function getFromCache(catID){
				return(globals.cache[catID]);
			}
			
			
			//-----------------------------------------------
			//put the data, and start the gallery
			function init_gallery(objItems,container){
				var html = generateGalleryHtml(objItems);
				//put gallery html
				$(container).html(html);
				
				//remove gallery focus rectangle
				$(container).find("a").focus(function(){
					this.blur();
				});
				
				startGallery(container);
			}
			
			//-------------------------------------------
			//adcivate custom js event functions, each with it's parameters
			function activateEvent(eventName){
				switch(eventName){
					case "before_load":
						if(typeof final_options.event_before_load == "function"){
							final_options.event_before_load();
						}
					break;
					case "after_load":
						if(typeof final_options.event_after_load == "function"){
							final_options.event_after_load();
						}
					break;
					case "get_catlist":
						if(typeof final_options.event_get_catlist == "function"){
							final_options.event_get_catlist(globals.catlist);
						}
					break;
					case "nav_click":
						if(typeof final_options.event_nav_click == "function"){
							var catname = getCatNameFromID(final_options.catid);
							final_options.event_nav_click(final_options.catid,catname);
						}						
					break;
				}				
			}
			
			//-----------------------------------------------
			//get category title from category id
			function getCatNameFromID(catid){
				for(var i=0;i<globals.catlist.length;i++){
					if(Number(catid) == Number(globals.catlist[i].id))
						return(globals.catlist[i].name);
				}
				return("");
			}
			
			//-------------------------------------------
			//put gallery navigation
			function putNavigation(galleryContainerID,containerID,type){
				
				//type = custom
				var navClass = "gallery_navigation";
				
				if(type == "hor")
					navClass = "gallery_navigation_hor";
					
				if(type == "vert")
					navClass = "gallery_navigation_vert";
					
				var html = "";
				
				//put table wrapper for not custom navigation
				if(type != "custom")
					html += "<table><tr><td>";
				
				html += "<ul class='"+navClass+"'>";
				var liClassString = "",liClass = "";
				
				$.each(globals.catlist, function(key, navitem){
					//set list item class
					liClass = "";
					
					//add selected
					if(Number(globals.settings.category) == Number(navitem.id))
						liClass = "selected";
						
					//add first
					if(key == 0){
						if(liClass != "") liClass += " ";
						liClass += "first";
					}
					
					//add last
					if(key == (globals.catlist.length-1)){
						if(liClass != "") liClass += " ";
						liClass += "last";
					}
					
					liClassString = "";
					liClassString = " class='"+liClass+"'";
					
					html += "<li "+liClassString+">";
					
					html += "<a onfocus='this.blur()' onclick='javascript:$(\"#"+galleryContainerID+"\").putEasyGallery({catid:"+navitem.id+",fromnavitem:this});' href='javascript:void(0)'>";
					html += "<span>"+navitem.name+"</span></a></li>";
				});
				
				html += "</ul>";
				
				//close table wrapper for not custom navigation
				if(type != "custom")
					html += "</td></tr></table>";
					
				$(containerID).html(html);
			}
			
			//-----------------------------------
			//change selected navigation item
			function changeSelectedNavItem(navItemLink){
				var li = $(navItemLink).parent();
				var ul = li.parent();
				ul.find("li").removeClass("selected");
				li.addClass("selected");
			}
						
			//-----------------------------------
			//set hash url for deeplinking
			function setDeeplink(catid){
				location.hash = "catid="+catid;
			}
			
			//-----------------------------------
			//get the deeplinking category id
			function getDeeplink(){
				var hash = location.hash;
				if(hash == "") return("");
				var catid = hash.replace("#catid=","")				
				if(catid == "") return("");
				if(isNaN(parseInt(catid)) == false) return(catid);
				else return("");
			}

			//-----------------------------------
			//start the gallery - using the container
			function startGallery(container){
			
				var objGallerySettings = {
					overlayOpacity:Number(globals.settings.view_overlay_opacity),
					overlayBgColor:globals.settings.view_overlay_color,
					fixedNavigation:eval(globals.settings.view_fixed_navigation),
					containerResizeSpeed:Number(globals.settings.view_resize_speed),
					showNumbersText:eval(globals.settings.view_show_text_numbers),
					txtImage:globals.settings.view_txt_image,
					txtOf:globals.settings.view_txt_of,
					keyToClose:globals.settings.view_key_close,
					keyToPrev:globals.settings.view_key_prev,
					keyToNext:globals.settings.view_key_next,
					imageLoading:globals.settings.images_admin_url+'lightbox-ico-loading.gif',
					imageBtnPrev:globals.settings.images_admin_url+'lightbox-btn-prev.gif',
					imageBtnNext:globals.settings.images_admin_url+'lightbox-btn-next.gif',
					imageBtnClose:globals.settings.images_admin_url+'lightbox-btn-close.gif',
					imageBlank:globals.settings.images_admin_url+'lightbox-blank.gif'
				}
				
				//set custom images url if set
				if(globals.settings.view_use_images_default_url == "false"){
					objGallerySettings.imageLoading = globals.settings.view_image_loading;
					objGallerySettings.imageBtnPrev = globals.settings.view_image_prev;
					objGallerySettings.imageBtnNext = globals.settings.view_image_next;
					objGallerySettings.imageBtnClose = globals.settings.view_image_close;
					objGallerySettings.imageBlank = globals.settings.view_image_blank;
				}
				
				$(function(){
					$(container).find("a").lightBox(objGallerySettings);
				});				
			}
			
			//-----------------------------------
			//output the error to the container
			function errorOutput(container,message){
				var outputMessage;
				if(message)
					outputMessage = message;
				else 
					outputMessage = responseMessage;
					
				var html="<span style='color:#DD290D;'>"+outputMessage+"</span>"
				$(container).html(html);
			}
			
			//-----------------------------------
			//load css file with specific url
			function loadCssFile(url){
				  var fileref = document.createElement("link");
				  fileref.setAttribute("rel", "stylesheet");
				  fileref.setAttribute("type", "text/css");
				  fileref.setAttribute("href", url);
				  document.getElementsByTagName("head")[0].appendChild(fileref);
			}
			
			//-------------------------------------------------
			//generate download image url
			function generateDownloadUrl(base,filename){
				var url = base + "?action=download&img="+filename;
				return(url);
			}
			
			//--------------------------------------------------
			//generate image src url from the admin
			function generateImageUrl(base,filename,width,height,exact){
				var url = base + "?img="+filename;
				if(width) url += "&w="+width;
				if(height) url += "&h="+height;
				if(exact == true) url += "&t=exact";
				return(url);
			}
			
			//--------------------------------------
			//generate an html for thumb item
			function getItemHtml(objItem){			
				var urlThumb = generateImageUrl(final_options["url_server"],objItem.filename,globals.settings.thumb_image_width,globals.settings.thumb_image_height,true);
				
				//set image url
				var urlImage;
				if(globals.settings.view_image_resize == "true")	//resize image
					urlImage = generateImageUrl(final_options["url_server"],objItem.filename,globals.settings.view_image_width,globals.settings.view_image_height);
				else		//don't resize image
					urlImage = generateImageUrl(final_options["url_server"],objItem.filename);
				
				var urlDownload = generateDownloadUrl(final_options["url_server"],objItem.filename);
				var desc = objItem.description;
				var title = objItem.title;
				
				if(desc == null) desc = "";
				
				var lightboxText = "";
				switch(globals.settings.view_text_fields){
					case "caption":
						lightboxText = "<span class='lightbox_text_title'>"+title+"</span>";
					break;
					case "desc":
						lightboxText = "<span class='lightbox_text_desc'>"+desc+"</span>";
					break;
					default:
					case "both":						
						lightboxText = "<span class='lightbox_text_title'>"+title+"</span>";
						
						//add delimiter
						if(desc.length>0)
							lightboxText += "<span class='lightbox_text_sap'></span>";
							
						lightboxText += "<span class='lightbox_text_desc'>"+desc+"</span>";
					break;
				}								
				
				var html = '';
				html += '<li title="'+title+'">';
					html += '<a href="'+urlImage+'" name="'+lightboxText+'">';
					
					if(globals.settings.thumb_text == "true" && globals.settings.thumb_text_vert_pos == "top")
						html += '<span>'+title+'</span>';
						
					html += '<div><img title="'+title+'" alt="&nbsp;" src="'+urlThumb+'" /></div>';
					
					if(globals.settings.thumb_text == "true" && globals.settings.thumb_text_vert_pos == "bottom")
						html += '<span>'+title+'</span>';
					
					html += '</a>';
				html += '</li>';
				return(html);
			}
			
			
			//-----------------------------------
			//get items html
			function getThumbsHtml(objItems){
				var html = "";
				
				//display empty text on empty category
				if(objItems.length == 0){
					if(globals.settings.empty_category_display_text == "true"){
						//set empty category class
						var emptyCssClass = "gallery_empty_category";	//default class
						if(globals.settings.empty_category_use_custom_class == "true")
							emptyCssClass = globals.settings.empty_category_class;	//set custom class
						
						html = "<div class='"+emptyCssClass+"'>"+globals.settings.empty_category_text+"</div>";
					}
					return(html);						
				}
				
				var objItem;
				html = "<ul class='list_gallery'>";				
				//table layout
				if(globals.settings.thumbs_columns_enable == "true"){
					var numCols = Number(globals.settings.thumbs_num_cols);
					html += "<table cellpadding='0' cellspacing='0' class='table_gallery'>";
					html += "<tr>"
					var flagFirstCol = true;
					for(var i=0;i<objItems.length;i++){						
						objItem = objItems[i];
						
						//add row and vertical delimiter
						if(i%numCols == 0 && i!=0){
							html += "</tr><tr><td class='sap_vert'></td></tr><tr>";
							flagFirstCol = true;
						}
						
						if(flagFirstCol == false)
							html += "<td class='sap_hor'></td>"
						
						//add column
						html += "<td>"
						html += getItemHtml(objItem);
						html += "</td>"						
						flagFirstCol = false;
					}
					html += "</tr>"
					html += "</table>";
				}				
				else{		//Dynamic layout
					for(var i=0;i<objItems.length;i++){
						objItem = objItems[i];
						html += getItemHtml(objItem);					
					}
				}
				
				html += "</ul>";
				return(html);
			}
			
			//-----------------------------------
			//generate a gallery html
			function generateGalleryHtml(objItems){
				var html = getThumbsHtml(objItems);
				return(html);
			}
			
			return(this);
        }
     });
})(jQuery);